/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.compute;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.assets.Validator;
import org.netbeans.modules.cloud.oracle.compute.Bundle;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public final class ComputeInstanceItem
extends OCIItem
implements URLProvider,
Validator {
    private final String AARCH = "aarch64";
    private String publicIp = null;
    private String processorDescription;
    private String username;
    private String imageId;

    public ComputeInstanceItem(OCID id, String compartmentId, String name, String processorDescription, String imageId, String publicIp, String username, String tenancyId, String regionCode) {
        super(id, compartmentId, name, tenancyId, regionCode);
        this.processorDescription = processorDescription;
        this.publicIp = publicIp;
        this.username = username;
        this.imageId = imageId;
    }

    public ComputeInstanceItem() {
    }

    public String getPublicIp() {
        if (this.publicIp == null) {
            return "-";
        }
        return this.publicIp;
    }

    public String getProcessorDescription() {
        return this.processorDescription;
    }

    public String getUsername() {
        return this.username;
    }

    void setUsername(String username) {
        this.username = username;
    }

    public String getImageId() {
        return this.imageId;
    }

    void setPublicId(String publicIp) {
        this.publicIp = publicIp;
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/compute/instances/%s?region=%s", this.getKey().getValue(), this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public Validator.Result validate() {
        boolean shape_arm;
        String osArch = System.getProperty("os.arch");
        String shapeDesc = this.getProcessorDescription();
        boolean os_arm = "aarch64".equals(osArch);
        boolean bl = shape_arm = shapeDesc != null && shapeDesc.contains("Ampere");
        if (os_arm == shape_arm) {
            return new Validator.Result(Validator.ValidationStatus.OK, null);
        }
        if (os_arm && !shape_arm) {
            return new Validator.Result(Validator.ValidationStatus.WARNING, Bundle.SuggestAmpere());
        }
        return new Validator.Result(Validator.ValidationStatus.WARNING, Bundle.SuggestIntel());
    }
}

